<?php
    $testContent = getContent('testimonials.content', true);
    $testElements = getContent('testimonials.element', false);
?>

<!-- Section Starts Here -->
    <section class="padding-bottom padding-top testimonial-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6 col-md-8">
                    <div class="section-header text-center">
                        <h2 class="title"><?php echo e(__(@$testContent->data_values->heading)); ?></h2>
                        <p><?php echo e(__(@$testContent->data_values->sub_heading)); ?></p>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center gy-5">
                <div class="col-lg-8 col-md-10">
                    <div class="testimonial-wrapper">
                        <div class="testimonial-slider">
                            <?php $__currentLoopData = $testElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="single-slider">
                                <div class="testimonial-item">
                                    <div class="content">
                                        <p><?php echo e(__(@$item->data_values->description)); ?></p>
                                    </div>
                                    <div class="thumb-wrapper">
                                        <div class="thumb">
                                            <img src="<?php echo e(getImage('assets/images/frontend/testimonials/'. @$item->data_values->image)); ?>" alt="testimonials">
                                        </div>
                                        <h5 class="name"><?php echo e(__(@$item->data_values->person)); ?></h5>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Section Ends Here -->
<?php /**PATH C:\xampp\htdocs\Files\core\resources\views/templates/basic/sections/testimonials.blade.php ENDPATH**/ ?>